#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

typedef unsigned char u08;

u08 font[256][8];

void makestrangearray_c(void);
void formatchar(u08 n, u08 *c);

int main(int argc, char **argv)
{
	FILE *in;
	unsigned int n = 0, i, j;
	u08 makearray = 0;
	
	if(argc < 2) return -1;
	
	in = fopen(argv[1], "rb");
	if(!in) return -2;
		
	for(j = 0 ; j<8 ; j++)
	{
		for(n=0 ; n<256 ; n++)
		{
		
			unsigned char b = 0;
			
			for(i=0 ; i<8 ; i++)
			{
				char c = fgetc(in);
				
				b <<= 1;
				
				b |= (c=='@') ? 1 : 0 ;
			}
		
			font[n][j] = b;
		}
	}
	
	for(n=0 ; n<256 ; n++)
		formatchar(n, font[n]);
			
	makestrangearray_c();

	printf("\n\n");
	
	return 0;
}

void makestrangearray_c()
{
	unsigned int x, y;
	
	printf("const uint8_t font[8*256] __attribute__ ((section (\".bigalign\"))) = \n");
	printf("{\n");
	
	for(y=0 ; y<8 ; y++)
	{
		printf("    ");
		for(x=0 ; x<256 ; x++)
			printf("0x%02x, ", font[x][y]);
		printf("\n");
	}
				
	printf("};\n");
}


// expects pointer to u08[8]
void formatchar(u08 n, u08 *c)
{
	u08 x, y;
	printf("\n\n%02x \'%c\':", n, isprint(n) ? n : '?');
	for(y=0 ; y<8 ; y++) // lines
	{
		u08 line = c[y];
		printf("\n");
		for(x=0 ; x<8 ; x++) // pixels
		{
			if(line & 0x80)
				printf("#");
			else
				printf(" ");
				
			line <<= 1;
		}
	}
}
