// 
// Demoprojekt fuer den Mikrocontrollerkurs (Teil 2), Sommersemester 2010
// 
// (c) 2010, ags, TU Braunschweig
//
//

#include <avr/io.h>
#include <util/delay.h>
#include <inttypes.h>

#include "lcd.h"
#include "accel.h"
#include "uart.h"
#include "xitoa.h"

void drawbox(uint8_t x, uint8_t y, uint8_t color)
{
	uint16_t i;
	lcd_window(x, y, x+10, y+10);
	for(i=0 ; i<(11*11) ; i++)
		lcd_wrdata(color);
}

int main()
{
	uint8_t box_x=0, box_y=0;

	uart_init();
	xfunc_out = (void (*)(char))uart_put; // connect printf to UART
	lcd_init();
	accel_init();

	xputs(PSTR("Mikrocontrollerkurs -- Teil 2 -- Sommersemester 2010"));

	lcd_clrscr();

	while(1)
	{
		// overwrite old box
		drawbox(box_x, box_y, 0xFF);
		
		accel_read(); // updates the global variables g_accel_[xyz]
		box_x = -g_accel_y+40;
		box_y = -g_accel_x+65;

		// paint new box		
		drawbox(box_x, box_y, 0x00);

		_delay_ms(50);
	}

	return 0;
}
